/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine;

import com.mojang.datafixers.util.Pair;
import dev.engine_room.flywheel.api.backend.Engine;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.InstanceHandle;
import dev.engine_room.flywheel.api.instance.InstanceType;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.backend.FlwBackend;
import dev.engine_room.flywheel.backend.engine.AbstractInstancer;
import dev.engine_room.flywheel.backend.engine.GroupKey;
import dev.engine_room.flywheel.backend.engine.InstanceHandleImpl;
import dev.engine_room.flywheel.backend.engine.InstancerKey;
import dev.engine_room.flywheel.backend.engine.LightStorage;
import dev.engine_room.flywheel.backend.engine.MaterialRenderState;
import dev.engine_room.flywheel.backend.engine.embed.Environment;
import dev.engine_room.flywheel.backend.engine.embed.EnvironmentStorage;
import dev.engine_room.flywheel.lib.task.ForEachPlan;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import net.minecraft.class_1088;
import org.jetbrains.annotations.Nullable;

public abstract class DrawManager<N extends AbstractInstancer<?>> {
    private static final boolean MODEL_WARNINGS = Boolean.getBoolean("flywheel.modelWarnings");
    protected final Map<InstancerKey<?>, N> instancers = new ConcurrentHashMap();
    protected final Queue<UninitializedInstancer<N, ?>> initializationQueue = new ConcurrentLinkedQueue();
    protected final Function<InstancerKey<?>, N> createAndDeferInit = this::createAndDeferInit;

    public <I extends Instance> AbstractInstancer<I> getInstancer(Environment environment, InstanceType<I> type, Model model, int bias) {
        return this.getInstancer(new InstancerKey<I>(environment, type, model, bias));
    }

    public <I extends Instance> AbstractInstancer<I> getInstancer(InstancerKey<I> key) {
        return (AbstractInstancer)this.instancers.computeIfAbsent(key, this.createAndDeferInit);
    }

    public Plan<RenderContext> createFramePlan() {
        return ForEachPlan.of(() -> new ArrayList<N>(this.instancers.values()), AbstractInstancer::parallelUpdate);
    }

    public void render(LightStorage lightStorage, EnvironmentStorage environmentStorage) {
        for (UninitializedInstancer uninitializedInstancer : this.initializationQueue) {
            AbstractInstancer instancer = (AbstractInstancer)uninitializedInstancer.instancer();
            if (instancer.instanceCount() > 0) {
                this.initialize(uninitializedInstancer.key(), instancer);
                continue;
            }
            this.instancers.remove(uninitializedInstancer.key());
        }
        this.initializationQueue.clear();
    }

    public void onRenderOriginChanged() {
        this.instancers.values().forEach(AbstractInstancer::clear);
    }

    public abstract void renderCrumbling(List<Engine.CrumblingBlock> var1);

    protected abstract <I extends Instance> N create(InstancerKey<I> var1);

    protected abstract <I extends Instance> void initialize(InstancerKey<I> var1, N var2);

    private N createAndDeferInit(InstancerKey<?> key) {
        N out = this.create(key);
        if (DrawManager.modelHasNoIssues(key.model())) {
            this.initializationQueue.add(new UninitializedInstancer(key, out));
        }
        return out;
    }

    private static boolean modelHasNoIssues(Model model) {
        if (model.meshes().isEmpty()) {
            if (MODEL_WARNINGS) {
                StringBuilder builder = new StringBuilder();
                builder.append("Creating an instancer for a model with no meshes! Stack trace:");
                StackWalker.getInstance().forEach(f -> builder.append("\n\t").append(f.toString()));
                FlwBackend.LOGGER.warn(builder.toString());
            }
            return false;
        }
        List<Model.ConfiguredMesh> meshes = model.meshes();
        for (int i = 0; i < meshes.size(); ++i) {
            Model.ConfiguredMesh mesh = meshes.get(i);
            if (MaterialRenderState.materialIsAllNonNull(mesh.material())) continue;
            if (MODEL_WARNINGS) {
                StringBuilder builder = new StringBuilder();
                builder.append("ConfiguredMesh at index ").append(i).append(" has null components in its material! Stack trace:");
                StackWalker.getInstance().forEach(f -> builder.append("\n\t").append(f.toString()));
                FlwBackend.LOGGER.warn(builder.toString());
            }
            return false;
        }
        return true;
    }

    protected static <I extends AbstractInstancer<?>> Map<GroupKey<?>, Int2ObjectMap<List<Pair<I, InstanceHandleImpl<?>>>>> doCrumblingSort(List<Engine.CrumblingBlock> crumblingBlocks, State2Instancer<I> cast) {
        HashMap byType = new HashMap();
        for (Engine.CrumblingBlock block : crumblingBlocks) {
            int progress = block.progress();
            if (progress < 0 || progress >= class_1088.field_21772.size()) continue;
            for (Instance instance : block.instances()) {
                InstanceHandle instanceHandle = instance.handle();
                if (!(instanceHandle instanceof InstanceHandleImpl)) continue;
                InstanceHandleImpl impl = (InstanceHandleImpl)instanceHandle;
                I instancer = cast.apply(impl.state);
                if (instancer == null) continue;
                ((List)byType.computeIfAbsent(new GroupKey(((AbstractInstancer)instancer).type, ((AbstractInstancer)instancer).environment), $ -> new Int2ObjectArrayMap()).computeIfAbsent(progress, $ -> new ArrayList())).add(Pair.of(instancer, (Object)impl));
            }
        }
        return byType;
    }

    public void delete() {
        this.instancers.clear();
        this.initializationQueue.clear();
    }

    public abstract void triggerFallback();

    protected record UninitializedInstancer<N, I extends Instance>(InstancerKey<I> key, N instancer) {
    }

    @FunctionalInterface
    protected static interface State2Instancer<I extends AbstractInstancer<?>> {
        @Nullable
        public I apply(InstanceHandleImpl.State<?> var1);
    }
}

